-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 22-10-2025 a las 18:35:51
-- Versión del servidor: 10.4.32-MariaDB
-- Versión de PHP: 8.0.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `wwcaam_caamth2025_caamth_mediapp`
--

DELIMITER $$
--
-- Procedimientos
--
CREATE DEFINER=CURRENT_USER PROCEDURE `sp_buscar_registros_cercanos` (IN `p_latitud` DECIMAL(10,8), IN `p_longitud` DECIMAL(11,8), IN `p_radio_metros` INT, IN `p_usuario_id` INT)   BEGIN
    DECLARE v_punto_referencia POINT;
    SET v_punto_referencia = POINT(p_longitud, p_latitud);
    
    -- Cortes de servicio cercanos
    SELECT 
        'corte_servicio' as tipo,
        id,
        numero_cuenta,
        numero_medidor,
        ST_Y(ubicacion) as latitud,
        ST_X(ubicacion) as longitud,
        fecha_registro,
        ST_Distance_Sphere(ubicacion, v_punto_referencia) as distancia_metros
    FROM cortes_servicio 
    WHERE usuario_id = p_usuario_id
    AND ST_Distance_Sphere(ubicacion, v_punto_referencia) <= p_radio_metros
    
    UNION ALL
    
    -- Medidores cercanos
    SELECT 
        'medidor' as tipo,
        id,
        cuenta,
        medidor,
        ST_Y(ubicacion) as latitud,
        ST_X(ubicacion) as longitud,
        fecha_registro,
        ST_Distance_Sphere(ubicacion, v_punto_referencia) as distancia_metros
    FROM medidores 
    WHERE usuario_id = p_usuario_id
    AND ST_Distance_Sphere(ubicacion, v_punto_referencia) <= p_radio_metros

    UNION ALL

    -- Notificadores cercanos
    SELECT
        'notificador' as tipo,
        id,
        SUBSTRING(observaciones, 1, 20) as cuenta, -- Usamos observaciones como referencia
        '' as medidor,
        ST_Y(ubicacion) as latitud,
        ST_X(ubicacion) as longitud,
        fecha_registro,
        ST_Distance_Sphere(ubicacion, v_punto_referencia) as distancia_metros
    FROM notificadores
    WHERE usuario_id = p_usuario_id
    AND ST_Distance_Sphere(ubicacion, v_punto_referencia) <= p_radio_metros
    
    ORDER BY distancia_metros ASC;
END$$

CREATE DEFINER=CURRENT_USER PROCEDURE `sp_insertar_corte_servicio` (IN `p_numero_cuenta` VARCHAR(20), IN `p_numero_medidor` VARCHAR(20), IN `p_suspension_agua` TINYINT, IN `p_suspension_drenaje` TINYINT, IN `p_foto_procedimiento_path` VARCHAR(500), IN `p_foto_cierre_path` VARCHAR(500), IN `p_latitud` DECIMAL(10,8), IN `p_longitud` DECIMAL(11,8), IN `p_precision_gps` DECIMAL(8,2), IN `p_usuario_id` INT)   BEGIN
    INSERT INTO cortes_servicio (
        numero_cuenta,
        numero_medidor,
        suspension_agua,
        suspension_drenaje,
        foto_procedimiento_path,
        foto_cierre_path,
        ubicacion,
        precision_gps,
        usuario_id
    ) VALUES (
        p_numero_cuenta,
        p_numero_medidor,
        p_suspension_agua,
        p_suspension_drenaje,
        p_foto_procedimiento_path,
        p_foto_cierre_path,
        POINT(p_longitud, p_latitud),
        p_precision_gps,
        p_usuario_id
    );
    
    SELECT LAST_INSERT_ID() as id;
END$$

CREATE DEFINER=CURRENT_USER PROCEDURE `sp_insertar_medidor` (IN `p_cuenta` VARCHAR(20), IN `p_medidor` VARCHAR(20), IN `p_lectura` VARCHAR(20), IN `p_foto_fachada_path` VARCHAR(500), IN `p_latitud` DECIMAL(10,8), IN `p_longitud` DECIMAL(11,8), IN `p_usuario_id` INT)   BEGIN
    INSERT INTO medidores (
        cuenta,
        medidor,
        lectura,
        foto_fachada_path,
        ubicacion,
        usuario_id
    ) VALUES (
        p_cuenta,
        p_medidor,
        p_lectura,
        p_foto_fachada_path,
        POINT(p_longitud, p_latitud),
        p_usuario_id
    );
    
    SELECT LAST_INSERT_ID() as id;
END$$

CREATE DEFINER=CURRENT_USER PROCEDURE `sp_insertar_notificacion` (IN `p_observaciones` TEXT, IN `p_foto_path` VARCHAR(500), IN `p_latitud` DECIMAL(10,8), IN `p_longitud` DECIMAL(11,8), IN `p_precision_gps` DECIMAL(8,2), IN `p_usuario_id` INT)   BEGIN
    INSERT INTO notificadores (
        observaciones,
        foto_path,
        ubicacion,
        precision_gps,
        usuario_id
    ) VALUES (
        p_observaciones,
        p_foto_path,
        POINT(p_longitud, p_latitud),
        p_precision_gps,
        p_usuario_id
    );
    
    SELECT LAST_INSERT_ID() as id;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `configuraciones`
--

CREATE TABLE `configuraciones` (
  `id` int(11) NOT NULL,
  `clave` varchar(100) NOT NULL,
  `valor` text DEFAULT NULL,
  `descripcion` text DEFAULT NULL,
  `fecha_actualizacion` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `configuraciones`
--

INSERT INTO `configuraciones` (`id`, `clave`, `valor`, `descripcion`, `fecha_actualizacion`) VALUES
(1, 'version_bd', '1.0', 'Versión de la base de datos', '2025-10-06 19:09:40'),
(2, 'tiempo_sincronizacion', '300', 'Tiempo en segundos entre sincronizaciones', '2025-10-06 19:09:40'),
(3, 'calidad_imagen', '85', 'Calidad de compresión de imágenes (0-100)', '2025-10-06 19:09:40'),
(4, 'gps_habilitado', '1', 'GPS habilitado para capturas', '2025-10-06 19:09:40'),
(5, 'max_intentos_sincronizacion', '3', 'Máximo número de intentos de sincronización', '2025-10-06 19:09:40');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cortes_servicio`
--

CREATE TABLE `cortes_servicio` (
  `id` int(11) NOT NULL,
  `numero_cuenta` varchar(20) NOT NULL,
  `numero_medidor` varchar(20) NOT NULL,
  `suspension_agua` tinyint(1) DEFAULT 0,
  `suspension_drenaje` tinyint(1) DEFAULT 0,
  `foto_procedimiento_path` varchar(500) DEFAULT NULL,
  `foto_cierre_path` varchar(500) DEFAULT NULL,
  `ubicacion` point NOT NULL,
  `precision_gps` decimal(8,2) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `fecha_corte` timestamp NULL DEFAULT current_timestamp(),
  `sincronizado` tinyint(1) DEFAULT 0,
  `intentos_sincronizacion` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `entregas_edificio`
--

CREATE TABLE `entregas_edificio` (
  `id` int(11) NOT NULL,
  `cuentas_json` text NOT NULL,
  `foto_path` varchar(500) NOT NULL,
  `ubicacion` point NOT NULL,
  `precision_gps` decimal(8,2) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `fecha_entrega` timestamp NULL DEFAULT current_timestamp(),
  `sincronizado` tinyint(1) DEFAULT 0,
  `intentos_sincronizacion` int(11) DEFAULT 0,
  `total_cuentas` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `entregas_individuales`
--

CREATE TABLE `entregas_individuales` (
  `id` int(11) NOT NULL,
  `cuenta` varchar(20) NOT NULL,
  `foto_path` varchar(500) NOT NULL,
  `ubicacion` point NOT NULL,
  `precision_gps` decimal(8,2) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `fecha_entrega` timestamp NULL DEFAULT current_timestamp(),
  `sincronizado` tinyint(1) DEFAULT 0,
  `intentos_sincronizacion` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `entregas_individuales`
--

INSERT INTO `entregas_individuales` (`id`, `cuenta`, `foto_path`, `ubicacion`, `precision_gps`, `usuario_id`, `fecha_registro`, `fecha_entrega`, `sincronizado`, `intentos_sincronizacion`) VALUES
(1, '50775', '/uploads/2025-10-07/1759853096619_7a74be45-40b2-413d-8b1f-71c8ba9f903b.jpg', 0x000000000101000000f1f44a5986c858c0e63fa4dfbe6e3340, 53.52, NULL, '2025-10-07 16:04:57', '2025-10-07 16:04:57', 0, 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_ubicaciones`
--

CREATE TABLE `historial_ubicaciones` (
  `id` bigint(20) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `ubicacion` point NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fecha_registro` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `historial_ubicaciones`
--

INSERT INTO `historial_ubicaciones` (`id`, `usuario_id`, `ubicacion`, `timestamp`, `fecha_registro`) VALUES
(1, 9, 0x0000000001010000009ce4a2b57dbe58c0b6b9313d61d93340, '2025-10-20 17:47:03', '2025-10-20 17:47:10'),
(2, 7, 0x0000000001010000000781f0fc7dbe58c07bcf921161d93340, '2025-10-20 17:47:28', '2025-10-20 17:47:35'),
(3, 9, 0x0000000001010000000076c9937fbe58c0f04fa91265d93340, '2025-10-20 17:47:46', '2025-10-20 17:47:52'),
(4, 9, 0x000000000101000000bfffa03f7ebe58c045fe4fb461d93340, '2025-10-20 17:47:51', '2025-10-20 17:47:57'),
(5, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 17:52:33', '2025-10-20 17:52:40'),
(6, 9, 0x0000000001010000009c29beeb7dbe58c081c0142f60d93340, '2025-10-20 17:52:46', '2025-10-20 17:52:57'),
(7, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 17:54:50', '2025-10-20 17:54:57'),
(8, 9, 0x0000000001010000000d86dff27dbe58c00aa41f6860d93340, '2025-10-20 17:54:56', '2025-10-20 17:55:03'),
(9, 9, 0x00000000010100000007e0b07e7dbe58c063bbd63961d93340, '2025-10-20 17:58:50', '2025-10-20 17:58:57'),
(10, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 17:58:53', '2025-10-20 17:59:01'),
(11, 9, 0x00000000010100000084d0e6dd7dbe58c08264f0e65fd93340, '2025-10-20 17:59:46', '2025-10-20 17:59:52'),
(12, 9, 0x000000000101000000ba707bdd7dbe58c058e542e55fd93340, '2025-10-20 18:00:06', '2025-10-20 18:00:12'),
(13, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:00:07', '2025-10-20 18:00:14'),
(14, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:01:57', '2025-10-20 18:02:04'),
(15, 9, 0x000000000101000000ddea39e97dbe58c052842fa75fd93340, '2025-10-20 18:01:59', '2025-10-20 18:02:08'),
(16, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:02:12', '2025-10-20 18:02:19'),
(17, 9, 0x0000000001010000001f679ab07dbe58c0402dab5560d93340, '2025-10-20 18:14:12', '2025-10-20 18:14:19'),
(18, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:14:12', '2025-10-20 18:14:19'),
(19, 9, 0x00000000010100000037925f9a7dbe58c08208cc9e5fd93340, '2025-10-20 18:14:25', '2025-10-20 18:14:26'),
(20, 9, 0x000000000101000000dc6e38e27fbe58c05078bfc062d93340, '2025-10-20 18:14:35', '2025-10-20 18:14:41'),
(21, 9, 0x000000000101000000e496a0d07cbe58c0d50627a25fd93340, '2025-10-20 18:14:45', '2025-10-20 18:14:51'),
(22, 9, 0x0000000001010000004859750c7ebe58c00ef9c2bf63d93340, '2025-10-20 18:15:06', '2025-10-20 18:15:12'),
(23, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:15:51', '2025-10-20 18:15:58'),
(24, 9, 0x000000000101000000014eefe27dbe58c0da7ba7b860d93340, '2025-10-20 18:15:49', '2025-10-20 18:16:00'),
(25, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:19:55', '2025-10-20 18:20:03'),
(26, 9, 0x000000000101000000dd8e15a17dbe58c0b701e9ac60d93340, '2025-10-20 18:20:31', '2025-10-20 18:20:37'),
(27, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:20:41', '2025-10-20 18:20:48'),
(28, 9, 0x000000000101000000317667927dbe58c0877d4cb560d93340, '2025-10-20 18:20:43', '2025-10-20 18:20:53'),
(29, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:23:22', '2025-10-20 18:23:29'),
(30, 9, 0x00000000010100000031a479b67dbe58c06f0d6c9560d93340, '2025-10-20 18:23:22', '2025-10-20 18:23:31'),
(31, 9, 0x00000000010100000061fa038a7dbe58c0ce29125d61d93340, '2025-10-20 18:33:34', '2025-10-20 18:33:41'),
(32, 10, 0x00000000010100000037058df47dbe58c0b144b12660d93340, '2025-10-20 18:41:35', '2025-10-20 18:41:44'),
(33, 10, 0x000000000101000000136058fe7cbe58c078c59d1c4fd93340, '2025-10-20 18:41:47', '2025-10-20 18:41:53'),
(34, 10, 0x0000000001010000005312c8db80be58c0527644cf77d93340, '2025-10-20 18:41:55', '2025-10-20 18:42:01'),
(35, 10, 0x000000000101000000dd465e317ebe58c0467a51bb5fd93340, '2025-10-20 18:44:36', '2025-10-20 18:44:44'),
(36, 9, 0x000000000101000000848bcba77dbe58c07bcf921161d93340, '2025-10-20 18:45:51', '2025-10-20 18:45:59'),
(37, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:46:03', '2025-10-20 18:46:11'),
(38, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:46:41', '2025-10-20 18:46:48'),
(39, 9, 0x00000000010100000049cf3ea07dbe58c081785dbf60d93340, '2025-10-20 18:46:41', '2025-10-20 18:46:52'),
(40, 9, 0x0000000001010000004fbd24847dbe58c0877d4cb560d93340, '2025-10-20 18:47:44', '2025-10-20 18:47:54'),
(41, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:47:59', '2025-10-20 18:48:06'),
(42, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:49:04', '2025-10-20 18:49:11'),
(43, 9, 0x000000000101000000d88926ab7dbe58c0f894528660d93340, '2025-10-20 18:49:31', '2025-10-20 18:49:38'),
(44, 10, 0x000000000101000000e98f0e2e74be58c0949b78c488d93340, '2025-10-20 18:49:21', '2025-10-20 18:50:33'),
(45, 10, 0x000000000101000000e5c3dd3869be58c0eee51754ced93340, '2025-10-20 18:49:21', '2025-10-20 18:50:41'),
(46, 10, 0x000000000101000000f524d5b164be58c0ed62f3740eda3340, '2025-10-20 18:49:21', '2025-10-20 18:50:52'),
(47, 10, 0x000000000101000000915942a757be58c08300e53f4ada3340, '2025-10-20 18:49:21', '2025-10-20 18:51:01'),
(48, 10, 0x0000000001010000001f26eb6c49be58c02abbac4f36da3340, '2025-10-20 18:49:21', '2025-10-20 18:51:10'),
(49, 10, 0x000000000101000000afc9fd9f37be58c0452a4b4209da3340, '2025-10-20 18:49:21', '2025-10-20 18:51:19'),
(50, 10, 0x000000000101000000554889dd34be58c0a9d6e5aa13da3340, '2025-10-20 18:49:21', '2025-10-20 18:51:33'),
(51, 10, 0x000000000101000000304dac6f44be58c0b5bb6339e1d93340, '2025-10-20 18:49:21', '2025-10-20 18:51:42'),
(52, 10, 0x0000000001010000005cabdc644ebe58c0b3d9ab1cd4d93340, '2025-10-20 18:49:21', '2025-10-20 18:51:51'),
(53, 10, 0x00000000010100000010a5c55953be58c01367d382cbd93340, '2025-10-20 18:49:21', '2025-10-20 18:52:00'),
(54, 10, 0x0000000001010000000b16cc7159be58c025f36249bfd93340, '2025-10-20 18:49:21', '2025-10-20 18:52:10'),
(55, 10, 0x00000000010100000019e114e95fbe58c0dcc4eeb48bd93340, '2025-10-20 18:49:21', '2025-10-20 18:52:19'),
(56, 10, 0x0000000001010000000054139b6dbe58c0f46f0e5173d93340, '2025-10-20 18:49:21', '2025-10-20 18:52:28'),
(57, 10, 0x000000000101000000c4afee3671be58c054b0c9ba67d93340, '2025-10-20 18:49:21', '2025-10-20 18:52:37'),
(58, 10, 0x0000000001010000004ea6153f74be58c0acb0518d62d93340, '2025-10-20 18:49:21', '2025-10-20 18:52:50'),
(59, 10, 0x000000000101000000e41ec86774be58c04c39bb6462d93340, '2025-10-20 18:49:21', '2025-10-20 18:53:10'),
(60, 10, 0x000000000101000000c363151476be58c026ae3e2b1fd93340, '2025-10-20 18:49:21', '2025-10-20 18:53:15'),
(61, 10, 0x00000000010100000063c5b55278be58c07434c44fd7d83340, '2025-10-20 18:49:21', '2025-10-20 18:53:24'),
(62, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:53:23', '2025-10-20 18:53:31'),
(63, 10, 0x000000000101000000cbf0da5b7dbe58c009d3309696d83340, '2025-10-20 18:49:21', '2025-10-20 18:53:51'),
(64, 9, 0x0000000001010000008a4b9f677dbe58c04ba71a6261d93340, '2025-10-20 18:53:50', '2025-10-20 18:53:58'),
(65, 10, 0x000000000101000000986e0f6d88be58c08cacc0f72ed83340, '2025-10-20 18:49:21', '2025-10-20 18:54:00'),
(66, 10, 0x000000000101000000d92264678abe58c0d5d4b4a617d83340, '2025-10-20 18:49:21', '2025-10-20 18:54:38'),
(67, 10, 0x0000000001010000007c41752e8bbe58c0cc127a8312d83340, '2025-10-20 18:49:21', '2025-10-20 18:55:01'),
(68, 10, 0x000000000101000000ee4cf3bf8cbe58c08e59d22fe0d73340, '2025-10-20 18:49:21', '2025-10-20 18:55:35'),
(69, 9, 0x00000000010100000090f1cddb7dbe58c0ab3fc23060d93340, '2025-10-20 18:56:46', '2025-10-20 18:56:57'),
(70, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-20 18:57:03', '2025-10-20 18:57:10'),
(71, 10, 0x0000000001010000006bdea40465c858c0e6e98eab39703340, '2025-10-20 18:56:30', '2025-10-20 18:57:39'),
(72, 10, 0x00000000010100000070917ed567c858c0ebf630d8f76f3340, '2025-10-20 18:56:30', '2025-10-20 18:57:48'),
(73, 10, 0x000000000101000000c8ee0f486fc858c05f01bc39fc6f3340, '2025-10-20 18:56:30', '2025-10-20 18:58:08'),
(74, 10, 0x00000000010100000073e9888078c858c0fd9e7f84f46f3340, '2025-10-20 18:56:30', '2025-10-20 18:58:18'),
(75, 7, 0x0000000001010000000000006037be58c0000000e01fd83340, '2025-10-22 16:34:10', '2025-10-22 16:34:17');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `infraestructura`
--

CREATE TABLE `infraestructura` (
  `id` int(11) NOT NULL,
  `foto_factura_path` varchar(500) NOT NULL,
  `fotos_trabajo_json` text DEFAULT NULL,
  `descripcion` text DEFAULT NULL,
  `ruta_audio_path` varchar(500) DEFAULT NULL,
  `duracion_audio` int(11) DEFAULT 0,
  `ubicacion` point NOT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `fecha_trabajo` timestamp NULL DEFAULT current_timestamp(),
  `sincronizado` tinyint(1) DEFAULT 0,
  `intentos_sincronizacion` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `log_acciones_admin`
--

CREATE TABLE `log_acciones_admin` (
  `id` bigint NOT NULL,
  `admin_id` int NOT NULL,
  `accion` varchar(100) NOT NULL,
  `recurso_afectado` varchar(100) DEFAULT NULL,
  `recurso_id` int DEFAULT NULL,
  `detalles` json DEFAULT NULL,
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `medidores`
--

CREATE TABLE `medidores` (
  `id` int(11) NOT NULL,
  `cuenta` varchar(20) NOT NULL,
  `medidor` varchar(20) NOT NULL,
  `lectura` varchar(20) NOT NULL,
  `foto_fachada_path` varchar(500) NOT NULL,
  `ubicacion` point NOT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `fecha_lectura` timestamp NULL DEFAULT current_timestamp(),
  `sincronizado` tinyint(1) DEFAULT 0,
  `intentos_sincronizacion` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `medidores`
--

INSERT INTO `medidores` (`id`, `cuenta`, `medidor`, `lectura`, `foto_fachada_path`, `ubicacion`, `usuario_id`, `fecha_registro`, `fecha_lectura`, `sincronizado`, `intentos_sincronizacion`) VALUES
(1, '7997', 'bdbd', '5959', '/uploads/2025-10-20/1760987513676_06688dd2-3d2c-44bf-a2dd-fcc9ebb1d536.jpeg', 0x00000000010100000096dfb3bf7dbe58c09f35e44460d93340, 9, '2025-10-20 19:11:53', '2025-10-20 19:11:53', 0, 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `notificadores`
--

CREATE TABLE `notificadores` (
  `id` int(11) NOT NULL,
  `observaciones` text DEFAULT NULL,
  `foto_path` varchar(500) NOT NULL,
  `ubicacion` point NOT NULL,
  `precision_gps` decimal(8,2) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `sincronizado` tinyint(1) DEFAULT 0,
  `intentos_sincronizacion` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `apellido_paterno` varchar(100) NOT NULL,
  `apellido_materno` varchar(100) NOT NULL,
  `numero_empleado` int(11) NOT NULL,
  `usuario` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `estatus_id` int(11) DEFAULT 1,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `ultimo_login` timestamp NULL DEFAULT NULL,
  `token_sesion` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`, `nombre`, `apellido_paterno`, `apellido_materno`, `numero_empleado`, `usuario`, `password_hash`, `estatus_id`, `fecha_registro`, `ultimo_login`, `token_sesion`) VALUES
(1, 'Carlos', 'Rodriguez', 'Martinez', 202402, 'carlos-202402', '1f73cfccedaf4bc68e7152a349bfcc9067c46bb2b10c6201c5dd5695e9f1ec78', 1, '2025-10-06 20:43:22', '2025-10-06 21:21:37', NULL),
(2, 'Nicolás', 'Hernández', 'Maldonado', 1, 'Nicolás-HM-001', '0047b2c981c5e658e499dcd7f710c7b5c4acabcc55ab6e20ea158bbd476e12cd', 1, '2025-10-07 15:58:36', '2025-10-07 17:25:06', NULL),
(3, 'Nicolas', 'HERNADEZ', 'MALDONADO', 6776, 'NiTO6776', '$2b$10$Q5qVcrXHEiS0IcILpCEjZO1YS21Voar4CrkmBjGawoSeGAfHPgxiy', 1, '2025-10-16 22:27:14', '2025-10-17 18:38:06', NULL),
(4, 'Nicolás', 'Hernández', 'Maldonado', 142553, 'Nicolás-HM-142553', '$2b$10$Fqy4lV5kp3YAmKDVFpLljeKak7ebcuSG98f872HxFoQNr.F09nHmi', 1, '2025-10-17 21:57:59', NULL, NULL),
(7, 'Tito', 'Ppp', 'Ppp', 15, 'Tito-PP-15', '$2b$10$l26.BA1/8q8c2jDEU2HE/.7vFYmDOWjpcyW6xX484gBfmcbZGMCTC', 1, '2025-10-17 21:58:41', '2025-10-22 16:34:10', NULL),
(9, 'Nicolas', 'HERNANDEZ', 'Maldo', 67761, 'Nicolas-HM-67761', '$2b$10$qpM.cVUsgJnSr0yOCidlp.nyE5wr5xlosQG2V0xLuQH/9PJNqprgG', 1, '2025-10-20 15:25:37', '2025-10-20 18:14:10', NULL),
(10, 'Carlos', 'Pepe', 'Pipe', 131, 'Carlos-PP-131', '$2b$10$8qIG4RU8esb78CDAHintNOemUO54DbhQBGMdASrCuVBdSSIY.W4.S', 1, '2025-10-20 18:41:02', '2025-10-20 18:41:32', NULL);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vista_coordenadas`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vista_coordenadas` (
`tipo_registro` varchar(21)
,`id` int(11)
,`referencia` varchar(20)
,`longitud` double
,`latitud` double
,`fecha_registro` timestamp
,`usuario_id` int(11)
,`observaciones` text
,`foto_path` varchar(500)
);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vista_estadisticas_diarias`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vista_estadisticas_diarias` (
`fecha` date
,`total_registros` bigint(21)
,`cortes` decimal(22,0)
,`medidores` decimal(22,0)
,`entregas_individuales` decimal(22,0)
);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vista_pendientes_sincronizacion`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vista_pendientes_sincronizacion` (
`tabla` varchar(21)
,`id` int(11)
,`usuario_id` int(11)
,`fecha_registro` timestamp
,`referencia` varchar(43)
);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vista_resumen_actividades`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vista_resumen_actividades` (
`usuario_id` int(11)
,`usuario` varchar(50)
,`nombre_completo` varchar(201)
,`total_cortes` bigint(21)
,`total_entregas_individuales` bigint(21)
,`total_entregas_edificio` bigint(21)
,`total_infraestructuras` bigint(21)
,`total_medidores` bigint(21)
,`total_notificadores` bigint(21)
,`ultimo_corte` timestamp
,`ultima_lectura` timestamp
);

-- --------------------------------------------------------

--
-- Estructura para la vista `vista_coordenadas`
--
DROP TABLE IF EXISTS `vista_coordenadas`;

CREATE ALGORITHM=UNDEFINED DEFINER=CURRENT_USER SQL SECURITY INVOKER VIEW `vista_coordenadas`  AS SELECT 'cortes_servicio' AS `tipo_registro`, `cs`.`id` AS `id`, `cs`.`numero_cuenta` AS `referencia`, st_x(`cs`.`ubicacion`) AS `longitud`, st_y(`cs`.`ubicacion`) AS `latitud`, `cs`.`fecha_registro` AS `fecha_registro`, `cs`.`usuario_id` AS `usuario_id`, NULL AS `observaciones`, `cs`.`foto_procedimiento_path` AS `foto_path` FROM `cortes_servicio` AS `cs`union all select 'entregas_individuales' AS `tipo_registro`,`ei`.`id` AS `id`,`ei`.`cuenta` AS `referencia`,st_x(`ei`.`ubicacion`) AS `longitud`,st_y(`ei`.`ubicacion`) AS `latitud`,`ei`.`fecha_registro` AS `fecha_registro`,`ei`.`usuario_id` AS `usuario_id`,NULL AS `observaciones`,`ei`.`foto_path` AS `foto_path` from `entregas_individuales` `ei` union all select 'medidores' AS `tipo_registro`,`m`.`id` AS `id`,`m`.`cuenta` AS `referencia`,st_x(`m`.`ubicacion`) AS `longitud`,st_y(`m`.`ubicacion`) AS `latitud`,`m`.`fecha_registro` AS `fecha_registro`,`m`.`usuario_id` AS `usuario_id`,NULL AS `observaciones`,`m`.`foto_fachada_path` AS `foto_path` from `medidores` `m` union all select 'notificadores' AS `tipo_registro`,`n`.`id` AS `id`,`n`.`observaciones` AS `referencia`,st_x(`n`.`ubicacion`) AS `longitud`,st_y(`n`.`ubicacion`) AS `latitud`,`n`.`fecha_registro` AS `fecha_registro`,`n`.`usuario_id` AS `usuario_id`,`n`.`observaciones` AS `observaciones`,`n`.`foto_path` AS `foto_path` from `notificadores` `n` ;

-- --------------------------------------------------------

--
-- Estructura para la vista `vista_estadisticas_diarias`
--
DROP TABLE IF EXISTS `vista_estadisticas_diarias`;

CREATE ALGORITHM=UNDEFINED DEFINER=CURRENT_USER SQL SECURITY INVOKER VIEW `vista_estadisticas_diarias`  AS SELECT cast(`vc`.`fecha_registro` as date) AS `fecha`, count(0) AS `total_registros`, sum(case when `vc`.`tipo_registro` = 'cortes_servicio' then 1 else 0 end) AS `cortes`, sum(case when `vc`.`tipo_registro` = 'medidores' then 1 else 0 end) AS `medidores`, sum(case when `vc`.`tipo_registro` = 'entregas_individuales' then 1 else 0 end) AS `entregas_individuales`, sum(case when `vc`.`tipo_registro` = 'notificadores' then 1 else 0 end) AS `notificadores` FROM `vista_coordenadas` AS `vc` GROUP BY cast(`vc`.`fecha_registro` as date) ORDER BY cast(`vc`.`fecha_registro` as date) DESC ;

-- --------------------------------------------------------

--
-- Estructura para la vista `vista_pendientes_sincronizacion`
--
DROP TABLE IF EXISTS `vista_pendientes_sincronizacion`;

CREATE ALGORITHM=UNDEFINED DEFINER=CURRENT_USER SQL SECURITY INVOKER VIEW `vista_pendientes_sincronizacion`  AS SELECT 'cortes_servicio' AS `tabla`, `cs`.`id` AS `id`, `cs`.`usuario_id` AS `usuario_id`, `cs`.`fecha_registro` AS `fecha_registro`, `cs`.`numero_cuenta` AS `referencia` FROM `cortes_servicio` AS `cs` WHERE `cs`.`sincronizado` = 0union allselect 'entregas_individuales' AS `entregas_individuales`,`ei`.`id` AS `id`,`ei`.`usuario_id` AS `usuario_id`,`ei`.`fecha_registro` AS `fecha_registro`,`ei`.`cuenta` AS `cuenta` from `entregas_individuales` `ei` where `ei`.`sincronizado` = 0 union all select 'entregas_edificio' AS `entregas_edificio`,`ee`.`id` AS `id`,`ee`.`usuario_id` AS `usuario_id`,`ee`.`fecha_registro` AS `fecha_registro`,concat('Edificio - ',`ee`.`total_cuentas`,' cuentas') AS `CONCAT('Edificio - ', ee.total_cuentas, ' cuentas')` from `entregas_edificio` `ee` where `ee`.`sincronizado` = 0 union all select 'infraestructura' AS `infraestructura`,`i`.`id` AS `id`,`i`.`usuario_id` AS `usuario_id`,`i`.`fecha_registro` AS `fecha_registro`,'Trabajo infraestructura' AS `Trabajo infraestructura` from `infraestructura` `i` where `i`.`sincronizado` = 0 union all select 'medidores' AS `medidores`,`m`.`id` AS `id`,`m`.`usuario_id` AS `usuario_id`,`m`.`fecha_registro` AS `fecha_registro`,concat(`m`.`cuenta`,' - ',`m`.`medidor`) AS `CONCAT(m.cuenta, ' - ', m.medidor)` from `medidores` `m` where `m`.`sincronizado` = 0 union all select 'notificadores' AS `tabla`,`n`.`id` AS `id`,`n`.`usuario_id` AS `usuario_id`,`n`.`fecha_registro` AS `fecha_registro`,`n`.`observaciones` AS `referencia` from `notificadores` `n` where `n`.`sincronizado` = 0 ;

-- --------------------------------------------------------

--
-- Estructura para la vista `vista_resumen_actividades`
--
DROP TABLE IF EXISTS `vista_resumen_actividades`;

CREATE ALGORITHM=UNDEFINED DEFINER=CURRENT_USER SQL SECURITY INVOKER VIEW `vista_resumen_actividades`  AS SELECT `u`.`id` AS `usuario_id`, `u`.`usuario` AS `usuario`, concat(`u`.`nombre`,' ',`u`.`apellido_paterno`) AS `nombre_completo`, count(distinct `cs`.`id`) AS `total_cortes`, count(distinct `ei`.`id`) AS `total_entregas_individuales`, count(distinct `ee`.`id`) AS `total_entregas_edificio`, count(distinct `inf`.`id`) AS `total_infraestructuras`, count(distinct `m`.`id`) AS `total_medidores`, count(distinct `n`.`id`) AS `total_notificadores`, max(`cs`.`fecha_registro`) AS `ultimo_corte`, max(`m`.`fecha_lectura`) AS `ultima_lectura` FROM ((((((`usuarios` `u` left join `cortes_servicio` `cs` on(`cs`.`usuario_id` = `u`.`id`)) left join `entregas_individuales` `ei` on(`ei`.`usuario_id` = `u`.`id`)) left join `entregas_edificio` `ee` on(`ee`.`usuario_id` = `u`.`id`)) left join `infraestructura` `inf` on(`inf`.`usuario_id` = `u`.`id`)) left join `medidores` `m` on(`m`.`usuario_id` = `u`.`id`)) left join `notificadores` `n` on(`n`.`usuario_id` = `u`.`id`)) GROUP BY `u`.`id`, `u`.`usuario`, `u`.`nombre`, `u`.`apellido_paterno` ;

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `configuraciones`
--
ALTER TABLE `configuraciones`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_configuraciones_clave` (`clave`);

--
-- Indices de la tabla `cortes_servicio`
--
ALTER TABLE `cortes_servicio`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_cortes_usuario` (`usuario_id`),
  ADD KEY `idx_cortes_cuenta` (`numero_cuenta`),
  ADD SPATIAL KEY `idx_ubicacion_cortes` (`ubicacion`);

--
-- Indices de la tabla `entregas_edificio`
--
ALTER TABLE `entregas_edificio`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD SPATIAL KEY `idx_ubicacion_edificio` (`ubicacion`);

--
-- Indices de la tabla `entregas_individuales`
--
ALTER TABLE `entregas_individuales`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD SPATIAL KEY `idx_ubicacion_entregas` (`ubicacion`);

--
-- Indices de la tabla `historial_ubicaciones`
--
ALTER TABLE `historial_ubicaciones`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_historial_usuario` (`usuario_id`),
  ADD SPATIAL KEY `idx_historial_ubicacion` (`ubicacion`),
  ADD KEY `idx_usuario_timestamp` (`usuario_id`,`timestamp`);

--
-- Indices de la tabla `infraestructura`
--
ALTER TABLE `infraestructura`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD SPATIAL KEY `idx_ubicacion_infra` (`ubicacion`);

--
-- Indices de la tabla `log_acciones_admin`
--
ALTER TABLE `log_acciones_admin`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_admin_id` (`admin_id`);

--
-- Indices de la tabla `medidores`
--
ALTER TABLE `medidores`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_medidores_usuario` (`usuario_id`),
  ADD KEY `idx_medidores_cuenta` (`cuenta`),
  ADD SPATIAL KEY `idx_ubicacion_medidores` (`ubicacion`);

--
-- Indices de la tabla `notificadores`
--
ALTER TABLE `notificadores`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD SPATIAL KEY `idx_ubicacion_notificadores` (`ubicacion`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_usuarios_numero_empleado` (`numero_empleado`),
  ADD UNIQUE KEY `uq_usuarios_usuario` (`usuario`),
  ADD KEY `idx_usuario` (`usuario`),
  ADD KEY `idx_numero_empleado` (`numero_empleado`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `configuraciones`
--
ALTER TABLE `configuraciones`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de la tabla `cortes_servicio`
--
ALTER TABLE `cortes_servicio`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `entregas_edificio`
--
ALTER TABLE `entregas_edificio`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `entregas_individuales`
--
ALTER TABLE `entregas_individuales`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `historial_ubicaciones`
--
ALTER TABLE `historial_ubicaciones`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=76;

--
-- AUTO_INCREMENT de la tabla `infraestructura`
--
ALTER TABLE `infraestructura`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `log_acciones_admin`
--
ALTER TABLE `log_acciones_admin`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `medidores`
--
ALTER TABLE `medidores`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `notificadores`
--
ALTER TABLE `notificadores`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `cortes_servicio`
--
ALTER TABLE `cortes_servicio`
  ADD CONSTRAINT `cortes_servicio_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Filtros para la tabla `entregas_edificio`
--
ALTER TABLE `entregas_edificio`
  ADD CONSTRAINT `entregas_edificio_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Filtros para la tabla `entregas_individuales`
--
ALTER TABLE `entregas_individuales`
  ADD CONSTRAINT `entregas_individuales_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Filtros para la tabla `historial_ubicaciones`
--
ALTER TABLE `historial_ubicaciones`
  ADD CONSTRAINT `fk_historial_usuario` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `infraestructura`
--
ALTER TABLE `infraestructura`
  ADD CONSTRAINT `infraestructura_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Filtros para la tabla `log_acciones_admin`
--
ALTER TABLE `log_acciones_admin`
  ADD CONSTRAINT `fk_log_admin` FOREIGN KEY (`admin_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `medidores`
--
ALTER TABLE `medidores`
  ADD CONSTRAINT `medidores_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Filtros para la tabla `notificadores`
--
ALTER TABLE `notificadores`
  ADD CONSTRAINT `notificadores_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
