import { pool } from '../config/db.js';

export const insertRegistroInfraestructura = async (infraData) => {
  const {
    descripcion, latitud, longitud, usuario_id,
    foto_factura_path, fotos_trabajo_paths, ruta_audio_path
  } = infraData;

  const [result] = await pool.execute(
    `INSERT INTO infraestructura
      (foto_factura_path, fotos_trabajo_json, descripcion, ruta_audio_path, ubicacion, usuario_id)
     VALUES (?, ?, ?, ?, POINT(?, ?), ?)`,
    [
      foto_factura_path,
      JSON.stringify(fotos_trabajo_paths),
      descripcion,
      ruta_audio_path,
      parseFloat(longitud),
      parseFloat(latitud),
      usuario_id
    ]
  );
  return result.insertId;
};