import { pool } from '../config/db.js';

export const insertEntregaIndividual = async (entregaData) => {
  const { cuenta, foto_path, latitud, longitud, precision_gps, usuario_id } = entregaData;

  const [result] = await pool.execute(
    `INSERT INTO entregas_individuales
      (cuenta, foto_path, ubicacion, precision_gps, usuario_id)
     VALUES (?, ?, POINT(?, ?), ?, ?)`,
    [cuenta, foto_path, parseFloat(longitud), parseFloat(latitud), parseFloat(precision_gps), usuario_id]
  );

  return result.insertId;
};

export const insertEntregaEdificio = async (entregaData) => {
  const { cuentas, foto_path, latitud, longitud, precision_gps, usuario_id } = entregaData;

  const cuentas_json = Array.isArray(cuentas) ? JSON.stringify(cuentas) : cuentas;
  const total_cuentas = JSON.parse(cuentas_json).length;

  const [result] = await pool.execute(
    `INSERT INTO entregas_edificio
      (cuentas_json, foto_path, ubicacion, precision_gps, usuario_id, total_cuentas)
     VALUES (?, ?, POINT(?, ?), ?, ?, ?)`,
    [
      cuentas_json, foto_path, parseFloat(longitud), parseFloat(latitud),
      parseFloat(precision_gps), usuario_id, total_cuentas
    ]
  );

  return {
    id: result.insertId,
    total_cuentas
  };
};