// Importa la librería Joi para la validación de esquemas.
import Joi from 'joi';

// --- ESQUEMA DE VALIDACIÓN PARA EL HISTORIAL DE USUARIO ---

// Lista blanca de tipos de registro válidos para el filtro.
const tiposDeRegistroValidos = [
  'corte_servicio',
  'entregas_individuales',
  'entregas_edificio',
  'infraestructura',
  'medidores',
  'notificadores'
];

export const historialUsuarioSchema = Joi.object({
  // `tipo_registro` es opcional. Si se proporciona, debe ser uno de los valores de la lista.
  tipo_registro: Joi.string().valid(...tiposDeRegistroValidos).optional(),

  // `page` y `limit` son opcionales y deben ser números enteros positivos.
  page: Joi.number().integer().min(1).optional(),
  limit: Joi.number().integer().min(1).optional()
});

export const coordenadasSchema = Joi.object({
  // `tipo_registro` es opcional y debe ser uno de los valores válidos.
  tipo_registro: Joi.string().valid(...tiposDeRegistroValidos).optional(),
  // `fecha_inicio` y `fecha_fin` son opcionales y deben ser fechas en formato ISO.
  fecha_inicio: Joi.date().iso().optional(),
  fecha_fin: Joi.date().iso().when('fecha_inicio', {
    is: Joi.exist(),
    then: Joi.date().min(Joi.ref('fecha_inicio')) // Si existe fecha_inicio, fecha_fin debe ser posterior.
  }).optional()
});

export const historialUbicacionesSchema = Joi.object({
  fecha_inicio: Joi.date().iso().required().messages({
    'any.required': 'El parámetro fecha_inicio es requerido.'
  }),
  fecha_fin: Joi.date().iso().min(Joi.ref('fecha_inicio')).required().messages({
    'any.required': 'El parámetro fecha_fin es requerido.',
    'date.min': 'La fecha_fin no puede ser anterior a la fecha_inicio.'
  })
});