import Joi from 'joi';

export const notificacionSchema = Joi.object({
  // `observaciones` es opcional y puede ser una cadena de texto vacía.
  observaciones: Joi.string().allow('').optional(),

  // Los campos de ubicación son requeridos y deben ser números válidos.
  latitud: Joi.number().required().messages({ 'number.base': 'La latitud debe ser un número válido' }),
  longitud: Joi.number().required().messages({ 'number.base': 'La longitud debe ser un número válido' }),
  precision_gps: Joi.number().required().messages({ 'number.base': 'La precisión del GPS debe ser un número válido' })
});