import Joi from 'joi';

// --- EXTENSIÓN DE JOI PARA MANEJAR UBICACIÓN ---
const joiWithUbicacion = Joi.extend((joi) => ({
  type: 'object',
  base: joi.object(),
  rules: {
    handleUbicacion: {
      method(enabled = true) {
        if (!enabled) {
          return this;
        }
        return this.custom((value, helpers) => {
          if (value.ubicacion && typeof value.ubicacion === 'object' && 'latitud' in value.ubicacion && 'longitud' in value.ubicacion) {
            value.latitud = value.ubicacion.latitud;
            value.longitud = value.ubicacion.longitud;
            delete value.ubicacion;
          }
          return value;
        }, 'Manejo de ubicación');
      }
    }
  }
}));

export const entregaIndividualSchema = joiWithUbicacion.object().handleUbicacion().keys({
  cuenta: Joi.string().required(),
  latitud: Joi.number().required(),
  longitud: Joi.number().required(),
  precision_gps: Joi.number().required()
});

export const entregaEdificioSchema = joiWithUbicacion.object().handleUbicacion().keys({
  cuentas: Joi.string().required(), // JSON string de un array
  latitud: Joi.number().required(),
  longitud: Joi.number().required(),
  precision_gps: Joi.number().required()
});