// --- IMPORTACIONES ---
import { Router } from 'express';
import multer from 'multer';
import { crearNotificacion } from '../controllers/notificadores.controller.js';
import { validate } from '../middlewares/validator.middleware.js';
import { notificacionSchema } from '../schemas/notificadores.schema.js';

// --- CONFIGURACIÓN DE MULTER ---
// Se configura para que guarde los archivos en memoria (buffer).
const storage = multer.memoryStorage();
const upload = multer({ storage });

// --- CREACIÓN DEL ENRUTADOR ---
const router = Router();

// --- DEFINICIÓN DE RUTAS ---
router.post('/', upload.single('foto'), validate(notificacionSchema), crearNotificacion);

export default router;