import { Router } from 'express';
import { crearRegistroInfraestructura } from '../controllers/infraestructura.controller.js';
import { upload } from '../middlewares/upload.middleware.js';
import { validate } from '../middlewares/validator.middleware.js';
import { infraestructuraSchema } from '../schemas/infraestructura.schema.js';

const router = Router();

router.post('/infraestructura',
  upload.fields([
    { name: 'foto_factura', maxCount: 1 },
    { name: 'fotos_trabajo', maxCount: 10 },
    { name: 'audio', maxCount: 1 }
  ]),
  validate(infraestructuraSchema),
  crearRegistroInfraestructura);

export default router;