import { Router } from 'express';
import { crearEntregaIndividual, crearEntregaEdificio } from '../controllers/entregas.controller.js';
import { upload } from '../middlewares/upload.middleware.js';
import { validate } from '../middlewares/validator.middleware.js';
import { entregaIndividualSchema, entregaEdificioSchema } from '../schemas/entregas.schema.js';

const router = Router();

router.post('/entregas-individuales', upload.single('foto'), validate(entregaIndividualSchema), crearEntregaIndividual);
router.post('/entregas-edificio', upload.single('foto'), validate(entregaEdificioSchema), crearEntregaEdificio);

export default router;