import { Router } from 'express';
import {
  getGenericViewData, // Importa el controlador genérico
} from '../controllers/admin.controller.js'; // Ajusta la ruta si es necesario
import {
  getActividadGeneral,
  getActividadGeorreferenciada,
  getAlertasDetalle,
  getAlertasOperativas,
  getCoordenadas,
  getCortesDetallados,
  getProductividadRadar,
} from './dashboard.controller.js'; // Corregido: Apunta al archivo en el directorio actual
import { validate } from '../middlewares/validator.middleware.js';
import { analiticasSchema } from '../schemas/admin.schema.js';

const router = Router();

router.get('/actividad-general', validate(analiticasSchema, 'query'), getActividadGeneral);
router.get('/actividad-georreferenciada', validate(analiticasSchema, 'query'), getActividadGeorreferenciada);
router.get('/alertas-detalle', validate(analiticasSchema, 'query'), getAlertasDetalle);
router.get('/alertas-operativas', getAlertasOperativas);
router.get('/coordenadas', validate(analiticasSchema, 'query'), getCoordenadas);
router.get('/cortes-detallados', validate(analiticasSchema, 'query'), getCortesDetallados);
router.get('/productividad-radar', validate(analiticasSchema, 'query'), getProductividadRadar);

// Ruta genérica para las vistas de ranking
router.get('/:viewName', getGenericViewData);

export default router;