import { pool } from '../config/db.js';
import { getAlertasOperativas as adminGetAlertasOperativas } from '../controllers/admin.controller.js';

const queryView = async (viewName, req, res, dateColumn = null) => {
  try {
    let query = `SELECT * FROM ${viewName}`;
    const params = [];
    if (dateColumn && req.query.fecha_inicio && req.query.fecha_fin) {
      query += ` WHERE ${dateColumn} BETWEEN ? AND ?`;
      params.push(req.query.fecha_inicio, req.query.fecha_fin);
    }
    const [rows] = await pool.query(query, params);
    res.json({ data: rows });
  } catch (error) {
    console.error(`Error fetching from ${viewName}:`, error);
    res.status(500).json({ message: 'Error interno del servidor' });
  }
};

export const getActividadGeneral = (req, res) => queryView('vista_actividad_general', req, res, 'fecha_registro');
export const getActividadGeorreferenciada = (req, res) => queryView('vista_actividad_georreferenciada', req, res, 'fecha_registro');
export const getAlertasDetalle = (req, res) => queryView('vista_alertas_detalle', req, res, 'fecha_registro');
export const getCoordenadas = (req, res) => queryView('vista_coordenadas', req, res, 'fecha_registro');
export const getCortesDetallados = (req, res) => queryView('vista_cortes_detallada', req, res, 'fecha_corte');
export const getProductividadRadar = (req, res) => queryView('vista_productividad_dashboard', req, res, 'fecha');

export const getAlertasOperativas = adminGetAlertasOperativas;