import { Router } from 'express';
import { crearCorteServicio, obtenerCortesServicio } from '../controllers/cortes.controller.js';
import { upload } from '../middlewares/upload.middleware.js';
import { validate } from '../middlewares/validator.middleware.js';
import { corteServicioSchema } from '../schemas/cortes.schema.js';

const router = Router();

router.route('/cortes-servicio')
  .get(obtenerCortesServicio)
  .post(
    upload.fields([
      { name: 'foto_procedimiento_path', maxCount: 1 },
      { name: 'foto_cierre_path', maxCount: 1 }
    ]),
    validate(corteServicioSchema),
    crearCorteServicio
  );

export default router;
