import { Router } from 'express';
import { login, registrar, getPerfil } from '../controllers/auth.controller.js';
import verificarToken from '../middlewares/auth.middleware.js';

const router = Router();

// --- RUTAS PÚBLICAS ---
// Estas rutas no requieren un token para ser accedidas.
router.post('/login', login);
router.post('/registrar', registrar);

// --- RUTA PROTEGIDA ---
// Esta ruta requiere un token válido para obtener los datos del perfil.
router.get('/perfil', verificarToken, getPerfil);

export default router;