import jwt from 'jsonwebtoken';

export function verificarToken(req, res, next) {
  try {
    const header = req.headers['authorization'] || '';
    const token = header.startsWith('Bearer ') ? header.slice(7) : header;
    if (!token) {
      return res.status(401).json({ ok: false, message: 'Token requerido' });
    }
    const payload = jwt.verify(token, process.env.JWT_SECRET);
    req.user = payload; // Mantenemos req.user para consistencia con los demás controladores
    next();
  } catch (err) {
    return res.status(401).json({ ok: false, message: 'Token inválido o expirado' });
  }
}

export default verificarToken;
