import * as ReportesService from '../services/reportes.service.js';

// --- OBTENER RESUMEN DE ACTIVIDADES ---
export const getResumenActividades = async (req, res) => {
  const usuarioId = req.user.id;
  const resumen = await ReportesService.fetchResumenActividades(usuarioId);
  res.json(resumen);
};

// --- OBTENER ESTADÍSTICAS DIARIAS ---
export const getEstadisticasDiarias = async (req, res) => {
  const usuarioId = req.user.id;
  const rows = await ReportesService.fetchEstadisticasDiarias(usuarioId);
  res.json(rows);
};

// --- OBTENER COORDENADAS PARA MAPA DE CALOR ---
export const getCoordenadas = async (req, res) => {
  const rows = await ReportesService.fetchCoordenadas(req.query);
  res.json(rows);
};

// --- OBTENER HISTORIAL DE UN USUARIO ---
export const getHistorialUsuario = async (req, res) => {
  const usuarioId = req.user.id;
  const resultado = await ReportesService.fetchHistorialUsuario(usuarioId, req.query);
  res.json(resultado);
};

// --- OBTENER REGISTROS CERCANOS ---
export const getRegistrosCercanos = async (req, res) => {
  const { latitud, longitud, radio } = req.query;
  const usuarioId = req.user.id;

  if (!latitud || !longitud || !radio) {
    return res.status(400).json({ message: 'Faltan parámetros de latitud, longitud o radio.' });
  }

  const registros = await ReportesService.fetchRegistrosCercanos(usuarioId, req.query);
  res.json(registros);
};

// --- OBTENER HISTORIAL DE UBICACIONES POR RANGO DE FECHAS ---
export const getHistorialUbicacionesPorFecha = async (req, res) => {
  const usuarioId = req.user.id;

  const resultado = await ReportesService.fetchHistorialUbicacionesPorFecha(usuarioId, req.query);
  res.json(resultado);
};
