import { compressAndSaveImage } from '../services/file.service.js';
import * as NotificadoresService from '../services/notificadores.service.js';

// --- CONTROLADOR PARA CREAR UNA NOTIFICACION ---
export const crearNotificacion = async (req, res) => {
  if (!req.file) {
    return res.status(400).json({ mensaje: 'La foto es requerida.' });
  }

  const usuario_id = req.user.id;
  const foto_path = await compressAndSaveImage(req.file.buffer);

  const notificacionData = { ...req.body, foto_path, usuario_id };
  const nuevoId = await NotificadoresService.insertNotificacion(notificacionData);

  res.status(201).json({
    id: nuevoId,
    mensaje: 'Notificacion registrada exitosamente'
  });
};