import { compressAndSaveImage } from '../services/file.service.js';
import * as MedidoresService from '../services/medidores.service.js';

// --- CONTROLADOR PARA CREAR UN REGISTRO DE LECTURA DE MEDIDOR ---
export const crearRegistroMedidor = async (req, res) => {
  const usuario_id = req.user.id;
  const foto_fachada_path = req.file ? await compressAndSaveImage(req.file.buffer) : null;

  const medidorData = { ...req.body, foto_fachada_path, usuario_id };
  const result = await MedidoresService.insertRegistroMedidor(medidorData);

  res.status(201).json({
    // El SP de medidor no devuelve el ID, así que usamos el insertId del resultado.
    id: result[0].insertId,
    mensaje: 'Lectura de medidor registrada exitosamente'
  });
};

// --- CONTROLADOR PARA OBTENER LAS LECTURAS DE MEDIDORES ---
export const obtenerMedidores = async (req, res) => {
  const usuario_id = req.user.id;
  const results = await MedidoresService.fetchMedidores(usuario_id);
  res.json(results);
};