import { compressAndSaveImage, compressAndSaveAudio } from '../services/file.service.js';
import * as InfraestructuraService from '../services/infraestructura.service.js';

// --- CONTROLADOR PARA CREAR UN REGISTRO DE INFRAESTRUCTURA ---
export const crearRegistroInfraestructura = async (req, res) => {
  const usuario_id = req.user.id;

  let foto_factura_path = null;
  let fotos_trabajo_paths = [];
  let ruta_audio_path = null;

  if (req.files['foto_factura']) {
    foto_factura_path = await compressAndSaveImage(req.files['foto_factura'][0].buffer);
  }

  if (req.files['fotos_trabajo']) {
    for (const file of req.files['fotos_trabajo']) {
      const compressedPath = await compressAndSaveImage(file.buffer);
      fotos_trabajo_paths.push(compressedPath);
    }
  }

  if (req.files['audio']) {
    ruta_audio_path = await compressAndSaveAudio(req.files['audio'][0].buffer);
  }

  const infraData = { ...req.body, usuario_id, foto_factura_path, fotos_trabajo_paths, ruta_audio_path };
  const nuevoId = await InfraestructuraService.insertRegistroInfraestructura(infraData);

  res.status(201).json({
    id: nuevoId,
    mensaje: 'Registro de infraestructura creado exitosamente'
  });
};