// Importa las librerías necesarias.
import jwt from 'jsonwebtoken';
import crypto from 'crypto';
import * as AuthService from '../services/auth.service.js';

// --- CONTROLADOR DE LOGIN (ACTUALIZADO) ---
export const login = async (req, res) => {
  console.log('Login request body:', req.body);
  const { usuario, password } = req.body;

  // --- MEJORA: Validar que los datos necesarios están presentes ---
  if (!usuario || !password) {
    return res.status(400).json({ error: 'El nombre de usuario y la contraseña son requeridos.' });
  }

  const user = await AuthService.findUserByUsername(usuario);

  if (!user) {
    return res.status(401).json({ error: 'Credenciales inválidas' });
  }

  const isMatch = await AuthService.comparePassword(password, user.password_hash);
  if (!isMatch) {
    return res.status(401).json({ error: 'Credenciales inválidas' });
  }

  await AuthService.updateLastLogin(user.id);

  const payload = {
    id: user.id,
    usuario: user.usuario,
    rol: user.rol, // <-- AÑADIMOS EL ROL AL TOKEN
  };

  const token = jwt.sign(payload, process.env.JWT_SECRET, {
    expiresIn: '1d', // El token expirará en 1 día.
  });

  delete user.password_hash;

  res.json({ token, user: user });
};

// --- CONTROLADOR DE REGISTRO (ACTUALIZADO) ---
export const registrar = async (req, res) => {
  try {
    const nuevoUsuario = await createUser(req.body);
    res.status(201).json(nuevoUsuario);
  } catch (error) {
    if (error.code === 'ER_DUP_ENTRY') {
      return res.status(409).json({ error: 'El usuario o número de empleado ya existe.' });
    }
    throw error;
  }
};

// --- CONTROLADOR PARA OBTENER EL PERFIL DEL USUARIO ---
export const getPerfil = async (req, res) => {
  // El middleware 'verificarToken' ya ha validado el token y adjuntado
  // el payload del usuario a 'req.user'.
  // No es necesario volver a consultar la base de datos si la información
  // en el token es suficiente.
  if (!req.user) {
    return res.status(404).json({ message: "Usuario no encontrado en token." });
  }

  // Devolvemos la información del usuario que está en el token.
  res.json(req.user);
};