import mysql from 'mysql2/promise';

// Limpiar variables de entorno
const cleanEnv = (value) => (value || '').trim();

// Pool MySQL usando variables de entorno
export const pool = mysql.createPool({
  host: cleanEnv(process.env.DB_HOST) || '127.0.0.1',
  port: Number(process.env.DB_PORT || 3306),
  user: cleanEnv(process.env.DB_USER) || 'wwcaam_mediapp',
  password: cleanEnv(process.env.DB_PASS) || 'CaaMth2025Access',
  database: cleanEnv(process.env.DB_NAME) || 'wwcaam_caamth2025_caamth_MediApp',
  waitForConnections: true,
  connectionLimit: Number(process.env.DB_CONN_LIMIT || 500),
  queueLimit: 0,
  dateStrings: true, // Devuelve fechas como strings 'YYYY-MM-DD HH:mm:ss'
  // namedPlaceholders: true // Opcional: permite usar :nombre en lugar de ?
});