import { pool } from '../config/db.js';

export const syncRegistros = async (registros, usuario_id) => {
  let conn;
  try {
    conn = await pool.getConnection();
    await conn.beginTransaction();

    const tablasPermitidas = [
      'cortes_servicio', 'entregas_individuales', 'entregas_edificio',
      'infraestructura', 'medidores', 'notificadores'
    ];

    for (const registro of registros) {
      if (!tablasPermitidas.includes(registro.tabla)) {
        const err = new Error(`Tabla no permitida para sincronización: ${registro.tabla}`);
        err.status = 400;
        throw err;
      }
      await conn.execute(
        `UPDATE ${registro.tabla} SET sincronizado = 1 WHERE id = ? AND usuario_id = ?`,
        [registro.id, usuario_id]
      );
    }

    await conn.commit();
  } catch (err) {
    if (conn) await conn.rollback();
    throw err;
  } finally {
    if (conn) conn.release();
  }
};