import { pool } from '../config/db.js';

export const insertNotificacion = async (notificacionData) => {
  const { observaciones, foto_path, latitud, longitud, precision_gps, usuario_id } = notificacionData;

  const [result] = await pool.execute(
    'CALL sp_insertar_notificacion(?, ?, ?, ?, ?, ?)',
    [observaciones, foto_path, parseFloat(latitud), parseFloat(longitud), parseFloat(precision_gps), usuario_id]
  );

  // El SP devuelve el ID en el primer array del resultado.
  return result[0][0].id;
};