import { pool } from '../config/db.js';

export const insertRegistroMedidor = async (medidorData) => {
  const { cuenta, medidor, lectura, foto_fachada_path, latitud, longitud, usuario_id } = medidorData;

  const [result] = await pool.execute(
    'CALL sp_insertar_medidor(?, ?, ?, ?, ?, ?, ?)',
    [cuenta, medidor, lectura, foto_fachada_path, parseFloat(latitud), parseFloat(longitud), usuario_id]
  );

  // Asumiendo que el SP devuelve el ID. Si no, habría que cambiarlo.
  // Por ahora, el controlador original usaba insertId, lo que sugiere que no devuelve el ID.
  // Vamos a devolver el objeto completo para que el controlador lo maneje.
  return result;
};

export const fetchMedidores = async (usuarioId) => {
  const [results] = await pool.execute(
    `SELECT
      id, cuenta, medidor, lectura, foto_fachada_path,
      ST_X(ubicacion) AS longitud, 
      ST_Y(ubicacion) AS latitud,
      fecha_registro, sincronizado
     FROM medidores
     WHERE usuario_id = ?
     ORDER BY fecha_registro DESC`,
    [usuarioId]
  );
  return results;
};