import { pool } from '../config/db.js';

export const insertCorteServicio = async (corteData) => {
  const {
    numero_cuenta, numero_medidor, suspension_agua, suspension_drenaje,
    foto_procedimiento_path, foto_cierre_path, latitud, longitud,
    precision_gps, usuario_id
  } = corteData;

  const [result] = await pool.execute(
    'CALL sp_insertar_corte_servicio(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
    [
      numero_cuenta, numero_medidor, suspension_agua, suspension_drenaje,
      foto_procedimiento_path, foto_cierre_path, parseFloat(latitud),
      parseFloat(longitud), parseFloat(precision_gps), usuario_id
    ]
  );

  return result[0][0].id;
};

export const fetchCortesServicio = async (usuarioId) => {
  const [results] = await pool.execute(
    `SELECT
      id, numero_cuenta, numero_medidor,
      suspension_agua, suspension_drenaje,
      foto_procedimiento_path, foto_cierre_path,
      ST_X(ubicacion) as longitud,
      ST_Y(ubicacion) as latitud,
      precision_gps, fecha_registro, sincronizado
     FROM cortes_servicio
     WHERE usuario_id = ?
     ORDER BY fecha_registro DESC LIMIT 100`,
    [usuarioId]
  );
  return results;
};