import { pool } from '../config/db.js';
import bcrypt from 'bcryptjs';

export const findUserByUsername = async (usuario) => {
  const query = `
    SELECT
      u.*,
      r.nombre as rol
    FROM usuarios u
    LEFT JOIN roles r ON u.rol_id = r.id
    WHERE u.usuario = ? AND u.estatus_id = 1`;
  const [userRows] = await pool.execute(query, [usuario]);
  return userRows[0];
};

export const comparePassword = async (password, hash) => {
  return await bcrypt.compare(password, hash);
};

export const updateLastLogin = async (userId) => {
  await pool.execute('UPDATE usuarios SET ultimo_login = CURRENT_TIMESTAMP WHERE id = ?', [userId]);
};

export const createUser = async (userData) => {
  const { nombre, apellido_paterno, apellido_materno, numero_empleado, usuario, password, rol_id } = userData;

  const salt = await bcrypt.genSalt(10);
  const password_hash = await bcrypt.hash(password, salt);

  const [result] = await pool.execute(
    'INSERT INTO usuarios (nombre, apellido_paterno, apellido_materno, numero_empleado, usuario, password_hash, rol_id) VALUES (?, ?, ?, ?, ?, ?, ?)',
    [nombre, apellido_paterno, apellido_materno, numero_empleado, usuario, password_hash, rol_id]
  );

  // Devuelve solo el ID para que el controlador pueda construir la respuesta.
  return result.insertId;
};