import Joi from 'joi';

export const medidorSchema = Joi.object({
  cuenta: Joi.string().trim().required(),
  medidor: Joi.string().trim().required(),
  lectura: Joi.string().trim().required(),
  // Cuando se usa multipart/form-data, los números llegan como strings.
  // Joi.number() los valida y convierte automáticamente.
  // Usamos .messages() para dar un error más claro si no es un número válido.
  latitud: Joi.number().required().messages({ 'number.base': 'La latitud debe ser un número válido' }),
  longitud: Joi.number().required().messages({ 'number.base': 'La longitud debe ser un número válido' })
});