// Importa la librería Joi para la validación de esquemas.
import Joi from 'joi';

// --- ESQUEMA DE VALIDACIÓN PARA EL LOGIN ---
export const loginSchema = Joi.object({
  // El campo 'usuario' debe ser un string, con un mínimo de 3 y máximo de 50 caracteres, y es requerido.
  usuario: Joi.string().min(3).max(50).required().messages({
    'string.base': `"usuario" debe ser de tipo texto`,
    'string.empty': `"usuario" no puede estar vacío`,
    'string.min': `"usuario" debe tener al menos {#limit} caracteres`,
    'any.required': `"usuario" es un campo requerido`
  }),
  // El campo 'password' debe ser un string, con un mínimo de 6 caracteres, y es requerido.
  password: Joi.string().min(6).required().messages({
    'string.empty': `"password" no puede estar vacía`,
    'string.min': `"password" debe tener al menos {#limit} caracteres`,
    'any.required': `"password" es un campo requerido`
  })
});

// --- ESQUEMA DE VALIDACIÓN PARA EL REGISTRO ---
export const registroSchema = Joi.object({
    nombre: Joi.string().min(2).max(50).required(),
    apellido_paterno: Joi.string().min(2).max(50).required(),
    apellido_materno: Joi.string().min(2).max(50).required(),
    // El 'numero_empleado' debe ser un string que solo contenga dígitos numéricos.
    numero_empleado: Joi.string().pattern(/^[0-9]+$/).required().messages({
        'string.pattern.base': `"numero_empleado" solo debe contener números`
    }),
    usuario: Joi.string().required(),
    password: Joi.string().min(6).required()
});