import { Router } from 'express';
import { crearRegistroMedidor, obtenerMedidores } from '../controllers/medidores.controller.js';
import { upload } from '../middlewares/upload.middleware.js';
import { validate } from '../middlewares/validator.middleware.js';
import { medidorSchema } from '../schemas/medidores.schema.js';

const router = Router();

router.route('/medidores')
  .get(obtenerMedidores)
  .post(upload.single('foto_fachada'), validate(medidorSchema), crearRegistroMedidor);

export default router;