// --- IMPORTACIONES ---
import { Router } from 'express';

// Routers por módulo
import authRoutes from './auth.routes.js';
import cortesRoutes from './cortes.routes.js';
import entregasRoutes from './entregas.routes.js';
import infraestructuraRoutes from './infraestructura.routes.js';
import medidoresRoutes from './medidores.routes.js';
import notificadoresRoutes from './notificadores.routes.js';
import reportesRoutes from './reportes.routes.js';
import sincronizacionRoutes from './sincronizacion.routes.js';
import configuracionRoutes from './configuracion.routes.js';
import adminRoutes from './admin.routes.js'; // Importa las nuevas rutas de admin
import dashboardRoutes from './dashboard.routes.js';

// DB para healthcheck
import { pool } from '../config/db.js';

// Middleware de auth (JWT)
import verificarToken from '../middlewares/auth.middleware.js';
import { verificarAdmin } from '../middlewares/admin.middleware.js'; // Importa el nuevo middleware

// --- CREACIÓN DEL ENRUTADOR PRINCIPAL ---
const router = Router();

/* ======================================================
   RUTAS PÚBLICAS (NO requieren token)
====================================================== */

// Healthcheck público: /api/health
router.get('/health', async (_req, res) => {
  await pool.execute('SELECT 1 AS status');
  res.json({
    status: 'OK',
    database: 'Conectado',
    timestamp: new Date().toISOString(),
  });
});

// Auth públicas: /auth/login, /auth/registro
router.use('/auth', authRoutes);

/* ======================================================
   A PARTIR DE AQUÍ, TODO REQUIERE TOKEN (JWT)
====================================================== */
// Se aplica el middleware de autenticación solo a las rutas que lo necesitan.
router.use('/cortes', verificarToken, cortesRoutes);
router.use('/entregas', verificarToken, entregasRoutes);
router.use('/infraestructura', verificarToken, infraestructuraRoutes);
router.use('/medidores', verificarToken, medidoresRoutes);
router.use('/notificadores', verificarToken, notificadoresRoutes);
router.use('/reportes', verificarToken, reportesRoutes);
router.use('/sincronizacion', verificarToken, sincronizacionRoutes);
router.use('/configuracion', verificarToken, configuracionRoutes);
// Se protegen las rutas de admin con ambos middlewares.
router.use('/admin', verificarToken, verificarAdmin, adminRoutes);
router.use('/dashboard', verificarToken, verificarAdmin, dashboardRoutes);

export default router;
