import { compressAndSaveImage } from '../services/file.service.js';
import * as EntregasService from '../services/entregas.service.js';

// --- CONTROLADOR PARA CREAR UNA ENTREGA INDIVIDUAL ---
export const crearEntregaIndividual = async (req, res) => {
  const usuario_id = req.user.id;
  const foto_path = req.file ? await compressAndSaveImage(req.file.buffer) : null;

  const entregaData = { ...req.body, foto_path, usuario_id };
  const nuevoId = await EntregasService.insertEntregaIndividual(entregaData);

  res.status(201).json({
    id: nuevoId,
    mensaje: 'Entrega individual registrada exitosamente'
  });
};

// --- CONTROLADOR PARA CREAR UNA ENTREGA EN EDIFICIO ---
export const crearEntregaEdificio = async (req, res) => {
  const usuario_id = req.user.id;
  const foto_path = req.file ? await compressAndSaveImage(req.file.buffer) : null;

  const entregaData = { ...req.body, foto_path, usuario_id };
  const { id, total_cuentas } = await EntregasService.insertEntregaEdificio(entregaData);

  res.status(201).json({
    id,
    mensaje: `Entrega en edificio registrada con ${total_cuentas} cuentas`
  });
};