import { compressAndSaveImage } from '../services/file.service.js';
import * as CortesService from '../services/cortes.service.js';

// --- CONTROLADOR PARA CREAR UN CORTE DE SERVICIO ---
export const crearCorteServicio = async (req, res) => {
  const usuario_id = req.user.id;

  let foto_procedimiento_path = null;
  let foto_cierre_path = null;

  if (req.files['foto_procedimiento_path']) {
    foto_procedimiento_path = await compressAndSaveImage(req.files['foto_procedimiento_path'][0].buffer);
  }
  if (req.files['foto_cierre_path']) {
    foto_cierre_path = await compressAndSaveImage(req.files['foto_cierre_path'][0].buffer);
  }

  const corteData = {
    ...req.body,
    suspension_agua: req.body.suspension_agua === 'true' || req.body.suspension_agua === true,
    suspension_drenaje: req.body.suspension_drenaje === 'true' || req.body.suspension_drenaje === true,
    foto_procedimiento_path,
    foto_cierre_path,
    usuario_id
  };

  const nuevoId = await CortesService.insertCorteServicio(corteData);

  res.status(201).json({
    id: nuevoId,
    mensaje: 'Corte de servicio registrado exitosamente'
  });
};

// --- CONTROLADOR PARA OBTENER CORTES DE SERVICIO ---
export const obtenerCortesServicio = async (req, res) => {
  const usuario_id = req.user.id;
  const results = await CortesService.fetchCortesServicio(usuario_id);
  res.json(results);
};