import swaggerJSDoc from 'swagger-jsdoc';

const swaggerOptions = {
  definition: {
    openapi: '3.0.0',
    info: {
      title: 'MediApp API',
      version: '1.0.0',
      description: 'Documentación de la API para la aplicación de gestión de mediciones y actividades en campo.',
      contact: {
        name: 'Soporte Técnico',
        email: 'soporte@example.com',
      },
    },
    servers: [
      {
        url: `http://localhost:${process.env.PORT || 3000}`,
        description: 'Servidor de Desarrollo',
      },
    ],
    // Define el esquema de seguridad para JWT
    components: {
      securitySchemes: {
        bearerAuth: {
          type: 'http',
          scheme: 'bearer',
          bearerFormat: 'JWT',
          description: 'Introduce el token JWT en el formato: Bearer {token}',
        },
      },
    },
    security: [
      {
        bearerAuth: [], // Aplica la seguridad JWT a nivel global
      },
    ],
  },
  // Apunta a los archivos de rutas para que se genere la documentación a partir de sus comentarios.
  apis: ['./src/routes/*.js'],
};

export const swaggerSpec = swaggerJSDoc(swaggerOptions);